unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TForm1 = class(TForm)
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
 
  protected
  //     
    procedure CreateParams(var p: TCreateParams); override;
    procedure WMSysCommand(var m: TMessage); message WM_SYSCOMMAND;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
procedure TForm1.CreateParams(var p: TCreateParams);
begin
  inherited;
  p.WndParent := 0;
end;

procedure TForm1.WMSysCommand(var m: TMessage);
begin
  m.Result := DefWindowProc(Handle, m.Msg, m.wParam, m.lParam);
end;


procedure TForm1.FormShow(Sender: TObject);
var
A,B : TRect;
Cursor: TPoint;
begin
GetCursorPos(Cursor);
A:= rect(Cursor.x,Cursor.y,0,0);
B:= Form1.BoundsRect;
DrawAnimatedRects(Form1.Handle, 3, A,B);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var
A, B: TRect;
begin
Form1.Visible:=false;
A:= rect(Screen.Width,Screen.Height,0,0);
B:= Form1.BoundsRect;
DrawAnimatedRects(Form1.Handle, 3, B,A);
end;

end.
 